/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CountDownLatch;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.Capture;
import net.sourceforge.peers.media.Encoder;
import net.sourceforge.peers.media.PcmaEncoder;
import net.sourceforge.peers.media.PcmuEncoder;
import net.sourceforge.peers.media.RtpSender;
import net.sourceforge.peers.media.SoundSource;
import net.sourceforge.peers.rtp.RtpSession;
import net.sourceforge.peers.sdp.Codec;

public class CaptureRtpSender {
    public static final int PIPE_SIZE = 4096;
    private RtpSession rtpSession;
    private Capture capture;
    private Encoder encoder;
    private RtpSender rtpSender;

    public CaptureRtpSender(RtpSession rtpSession, SoundSource soundSource, boolean mediaDebug, Codec codec, Logger logger, String peersHome) throws IOException {
        PipedInputStream encodedDataInput;
        PipedInputStream rawDataInput;
        this.rtpSession = rtpSession;
        CountDownLatch latch = new CountDownLatch(3);
        PipedOutputStream rawDataOutput = new PipedOutputStream();
        try {
            rawDataInput = new PipedInputStream(rawDataOutput, 4096);
        }
        catch (IOException e) {
            logger.error("input/output error", e);
            return;
        }
        PipedOutputStream encodedDataOutput = new PipedOutputStream();
        try {
            encodedDataInput = new PipedInputStream(encodedDataOutput, 4096);
        }
        catch (IOException e) {
            logger.error("input/output error");
            rawDataInput.close();
            return;
        }
        this.capture = new Capture(rawDataOutput, soundSource, logger, latch);
        switch (codec.getPayloadType()) {
            case 0: {
                this.encoder = new PcmuEncoder(rawDataInput, encodedDataOutput, mediaDebug, logger, peersHome, latch);
                break;
            }
            case 8: {
                this.encoder = new PcmaEncoder(rawDataInput, encodedDataOutput, mediaDebug, logger, peersHome, latch);
                break;
            }
            default: {
                encodedDataInput.close();
                rawDataInput.close();
                throw new RuntimeException("unknown payload type");
            }
        }
        this.rtpSender = new RtpSender(encodedDataInput, rtpSession, mediaDebug, codec, logger, peersHome, latch);
    }

    public void start() throws IOException {
        this.capture.setStopped(false);
        this.encoder.setStopped(false);
        this.rtpSender.setStopped(false);
        Thread captureThread = new Thread((Runnable)this.capture, Capture.class.getSimpleName());
        Thread encoderThread = new Thread((Runnable)this.encoder, Encoder.class.getSimpleName());
        Thread rtpSenderThread = new Thread((Runnable)this.rtpSender, RtpSender.class.getSimpleName());
        captureThread.start();
        encoderThread.start();
        rtpSenderThread.start();
    }

    public void stop() {
        if (this.capture != null) {
            this.capture.setStopped(true);
        }
        if (this.encoder != null) {
            this.encoder.setStopped(true);
        }
        if (this.rtpSender != null) {
            this.rtpSender.setStopped(true);
        }
    }

    public synchronized RtpSession getRtpSession() {
        return this.rtpSession;
    }

    public RtpSender getRtpSender() {
        return this.rtpSender;
    }
}

